/*******************************************************************************
  Main Source File

  Company:
    Microchip Technology Inc.

  File Name:
    main.c

  Summary:
    This file contains the "main" function for a project.

  Description:
    This file contains the "main" function for a project.  The
    "main" function calls the "SYS_Initialize" function to initialize the state
    machines of all modules in the system
 *******************************************************************************/

// *****************************************************************************
// *****************************************************************************
// Section: Included Files
// *****************************************************************************
// *****************************************************************************

#include <stddef.h>                     // Defines NULL
#include <stdbool.h>                    // Defines true
#include <stdlib.h>                     // Defines EXIT_FAILURE
#include "definitions.h"                // SYS function prototypes
#include "Inductor_Tester.h"
#include "LCD_lib_busy.h"
#include "LCD_config.h"
#include <xc.h>            
#include <sys/attribs.h> 
#include "interrupts.h"
#include "definitions.h"

// *****************************************************************************
// *****************************************************************************
// Section: Main Entry Point
// *****************************************************************************
// *****************************************************************************

int main ( void )
{
    /* Initialize all modules */
    SYS_Initialize ( NULL );

    // *************************************************************************************************
    // CPU Performance Optimization:
    // *************************************************************************************************
//    register unsigned long tmp_cache; //KSEG0 cache enable
//    asm("mfc0 %0,$16,0" : "=r"(tmp_cache));
//    tmp_cache = (tmp_cache & ~7) | 3;
//    asm("mtc0 %0,$16,0" :: "r" (tmp_cache));
//    CHECONbits.PFMWS=3; //Flash wait states = 3 CPU clock cycles @ 120Mhz
    
    while ( true )
    {
        /* Maintain state machines of all polled MPLAB Harmony modules. */
        Inductor_Tester_Tasks ( );
    }

    /* Execution should not come here during normal operation */

    return ( EXIT_FAILURE );
}


/*******************************************************************************
 End of File
*/

